/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ExportDataPanel;
import org.autoplot.RenderType;
import org.autoplot.datasource.AnonymousDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.GuiUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.Canvas;
import org.autoplot.dom.ChangesSupport;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomOps;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.jythonsupport.Util;
import org.autoplot.scriptconsole.ExitExceptionHandler;
import org.autoplot.state.StatePersistence;
import org.das2.DasApplication;
import org.das2.components.DataPointRecorder;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.TableDataSet;
import org.das2.dataset.TableUtil;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorUtil;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.Units;
import org.das2.event.BoxRenderer;
import org.das2.event.BoxSelectionListener;
import org.das2.event.BoxSelectorMouseModule;
import org.das2.event.DragRenderer;
import org.das2.event.MouseModule;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.graph.DasColorBar;
import org.das2.graph.DasPlot;
import org.das2.graph.Painter;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.DasPNGEncoder;
import org.das2.util.LoggerManager;
import org.das2.util.awt.GraphicsOutput;
import org.das2.util.awt.PdfGraphicsOutput;
import org.das2.util.awt.SvgGraphicsOutput;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Property;
import org.python.core.Py;
import org.python.core.PyFunction;
import org.python.core.PyJavaInstance;

public class ScriptContext2023
extends PyJavaInstance {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.script");
    private static final Logger resizeLogger = Logger.getLogger("autoplot.dom.canvas.resize");
    private State state;
    public static final String PNG_KEY_SCRIPT = "AutoplotScriptURI";
    public static final String PNG_KEY_VAP = "AutoplotVap";
    public static final String PNG_KEY_URI = "AutoplotURI";

    public ScriptContext2023() {
        logger.fine("new ScriptContext");
        this.state = new State();
    }

    private void setUpHeadlessExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "runtime exception: " + e, e);
                if (e instanceof InconvertibleUnitsException) {
                    return;
                }
                ScriptContext2023.this.state.model.getExceptionHandler().handleUncaught(e);
            }
        });
    }

    private synchronized void maybeInitModel() {
        if (this.state.model == null) {
            this.state.model = new ApplicationModel();
            this.state.model.setExceptionHandler(new ExitExceptionHandler());
            this.setUpHeadlessExceptionHandler();
            this.state.model.addDasPeersToAppAndWait();
            this.state.dom = this.state.model.getDom();
            this.state.dom.getController().setScriptContext(this);
        }
        if (this.state.view != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                if (!this.state.view.isVisible()) {
                    this.state.view.setVisible(true);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!ScriptContext2023.this.state.view.isVisible()) {
                            ScriptContext2023.this.state.view.setVisible(true);
                        }
                    }
                });
            }
        }
    }

    public synchronized void setApplication(AutoplotUI app) {
        this.setApplicationModel(app.applicationModel);
        this.setView(app);
        this.state.appLookup.put(app.applicationModel, app);
    }

    public synchronized void setDefaultApplication() {
        this.setApplication(this.state.defaultApp);
    }

    public synchronized void setWindow(ApplicationModel appm) {
        AutoplotUI app = (AutoplotUI)this.state.appLookup.get(appm);
        if (app == null) {
            this.state.view = null;
        } else {
            this.state.view = app;
        }
        this.setApplicationModel(appm);
    }

    public synchronized AutoplotUI getApplication() {
        return this.state.view;
    }

    public synchronized ApplicationModel getWindow() {
        return this.state.model;
    }

    public synchronized AutoplotUI newApplication(String id) {
        AutoplotUI result = (AutoplotUI)this.state.apps.get(id);
        if (result != null && !AppManager.getInstance().isRunningApplication(result)) {
            AutoplotUI app = (AutoplotUI)this.state.apps.remove(id);
            this.state.appLookup.remove(app.applicationModel);
            result = null;
        }
        if (result == null) {
            result = this.state.view.newApplication();
            result.setApplicationName(id);
            this.state.apps.put(id, result);
            this.state.appLookup.put(result.applicationModel, result);
        }
        return result;
    }

    public synchronized ApplicationModel newWindow(String id, int width, int height, int x, int y) {
        ApplicationModel result = this.newWindow(id);
        Window window = SwingUtilities.getWindowAncestor((Component)result.canvas);
        if (window != null) {
            Dimension windowDimension = window.getSize();
            Dimension canvasDimension = ((State)this.state).model.canvas.getSize();
            if (Math.abs(windowDimension.width - canvasDimension.width) > 100 || Math.abs(windowDimension.height - canvasDimension.height) > 100) {
                window.setSize(width + 2, height + 29);
            } else {
                window.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
            }
            window.setLocation(x, y);
        } else {
            ((State)this.state).model.canvas.setSize(width, height);
        }
        return result;
    }

    public synchronized void setWindowLocation(int x, int y) {
        Window window = SwingUtilities.getWindowAncestor((Component)this.getWindow().getCanvas());
        if (window != null) {
            window.setLocation(x, y);
        }
    }

    public synchronized ApplicationModel newDialogWindow(Window parent, String title) {
        final JDialog p = new JDialog(parent, title);
        ApplicationModel result = new ApplicationModel();
        result.addDasPeersToApp();
        if (!DasApplication.getDefaultApplication().isHeadless()) {
            p.getContentPane().add((Component)result.canvas);
            p.pack();
            p.setVisible(true);
        }
        result.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

            @Override
            public double resize(int width, int height) {
                resizeLogger.log(Level.FINE, "resize1 ({0},{1})", new Object[]{width, height});
                if (p != null) {
                    Dimension windowDimension = p.getSize();
                    Dimension canvasDimension = ((State)((ScriptContext2023)ScriptContext2023.this).state).model.canvas.getSize();
                    p.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
                }
                ((State)((ScriptContext2023)ScriptContext2023.this).state).model.canvas.setSize(width, height);
                return 1.0;
            }
        });
        return result;
    }

    public synchronized ApplicationModel newWindow(final String id) {
        ApplicationModel result = (ApplicationModel)this.state.applets.get(id);
        if (result == null) {
            JFrame j;
            result = new ApplicationModel();
            result.addDasPeersToApp();
            result.setName(id);
            this.state.applets.put(id, result);
            if (!DasApplication.getDefaultApplication().isHeadless()) {
                j = new JFrame(id);
                j.setIconImage(AutoplotUtil.getAutoplotIcon());
                j.getContentPane().add((Component)result.canvas);
                j.pack();
                j.setVisible(true);
                j.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ScriptContext2023.this.state.applets.remove(id);
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                        ScriptContext2023.this.state.applets.remove(id);
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }
                });
            } else {
                j = null;
            }
            result.setResizeRequestListener(new ApplicationModel.ResizeRequestListener(){

                @Override
                public double resize(int width, int height) {
                    resizeLogger.log(Level.FINE, "resize2 ({0},{1})", new Object[]{width, height});
                    if (j != null) {
                        Dimension windowDimension = j.getSize();
                        Dimension canvasDimension = ((State)((ScriptContext2023)ScriptContext2023.this).state).model.canvas.getSize();
                        j.setSize(width + (windowDimension.width - canvasDimension.width), height + (windowDimension.height - canvasDimension.height));
                    }
                    ((State)((ScriptContext2023)ScriptContext2023.this).state).model.canvas.setSize(width, height);
                    return 1.0;
                }
            });
        }
        return result;
    }

    public void setApplicationModel(ApplicationModel m) {
        this.state.model = m;
        this.state.dom = m.getDom();
    }

    protected void _setDefaultApp(AutoplotUI app) {
        this.state.defaultApp = app;
        if (app != null) {
            this.state.appLookup.put(app.applicationModel, app);
        }
    }

    private synchronized void maybeInitView() {
        this.maybeInitModel();
        if (this.state.view == null) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ScriptContext2023.this.state.view = new AutoplotUI(ScriptContext2023.this.state.model);
                    ScriptContext2023.this.state.view.setVisible(true);
                    ScriptContext2023.this.state.defaultApp = ScriptContext2023.this.state.view;
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        this.state.view.setMessage("ready");
    }

    protected void setView(AutoplotUI v) {
        this.state.view = v;
    }

    public Window getViewWindow() {
        return this.state.view;
    }

    public void _setOutputStream(OutputStream out) {
        this.state.out = out;
    }

    public void setCanvasSize(final int width, final int height) {
        this.maybeInitModel();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ScriptContext2023.this.state.model.setCanvasSize(width, height);
                ScriptContext2023.this.state.model.getDocumentModel().getCanvases(0).setSize(width, height);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                Logger.getLogger(ScriptContext2023.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void setDataSourceURL(String surl) {
        this.state.model.setDataSourceURL(surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(String suri) {
        this.maybeInitModel();
        if (this.state.view != null && this.state.view.isExpertMode()) {
            ((State)this.state).view.dataSetSelector.setValue(suri);
        }
        this.state.model.resetDataSetSourceURL(suri, (ProgressMonitor)new NullProgressMonitor());
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(String surl1, String surl2) {
        this.maybeInitModel();
        if (surl1.endsWith(".vap") || surl1.contains(".vap?")) {
            throw new IllegalArgumentException("cannot load vap here in two-argument plot");
        }
        DataSourceFilter dsf = this.state.dom.getDataSourceFilters(0);
        List<PlotElement> pes = this.state.dom.getController().getPlotElementsFor(dsf);
        PlotElement pe = !pes.isEmpty() ? pes.get(0) : null;
        Plot p = pe == null ? this.state.dom.getPlots(0) : this.state.dom.getController().getPlotFor(pe);
        this.state.dom.getController().doplot(p, pe, surl1, surl2);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String surl) {
        this.maybeInitModel();
        this.state.model.setDataSet(chNum, null, surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String label, String surl) {
        this.maybeInitModel();
        this.state.model.setDataSet(chNum, label, surl);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(QDataSet ds) {
        this.plot(0, (String)null, ds);
    }

    public void plot(QDataSet x, QDataSet y) {
        this.plot(0, (String)null, x, y);
    }

    public void plot(QDataSet x, QDataSet y, QDataSet z) {
        this.plot(0, (String)null, x, y, z);
    }

    public void plot(int chNum, QDataSet ds) {
        this.plot(chNum, (String)null, ds);
    }

    public void plot(int chNum, QDataSet x, QDataSet y) {
        this.plot(chNum, (String)null, x, y);
    }

    public void plot(int chNum, QDataSet x, QDataSet y, QDataSet z) {
        this.plot(chNum, (String)null, x, y, z);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DasColorBar.Type makeColorTable(String name, QDataSet index, QDataSet rgb) {
        int i;
        boolean implicitWarn = false;
        if (index == null) {
            index = Ops.indgen((int)rgb.length());
            implicitWarn = true;
        }
        int[] iindex = new int[index.length()];
        int[] red = new int[rgb.length()];
        int[] green = new int[rgb.length()];
        int[] blue = new int[rgb.length()];
        int bottom = 0;
        int top = 0;
        if (rgb.rank() == 1) {
            if (SemanticOps.getUnits((QDataSet)rgb) != Units.rgbColor) throw new IllegalArgumentException("only rank 2 bundle of R,G,B or rank 1 data with Units.rgbColor.");
            for (i = 0; i < iindex.length; ++i) {
                iindex[i] = (int)Math.round(index.value(i));
                red[i] = ((int)rgb.value(i) & 0xFF0000) >> 16;
                green[i] = ((int)rgb.value(i) & 0xFF00) >> 8;
                blue[i] = (int)rgb.value(i) & 0xFF;
                top = Math.max(top, iindex[i]);
            }
        } else {
            for (i = 0; i < iindex.length; ++i) {
                iindex[i] = (int)Math.round(index.value(i));
                red[i] = (int)Math.round(rgb.value(i, 0));
                green[i] = (int)Math.round(rgb.value(i, 1));
                blue[i] = (int)Math.round(rgb.value(i, 2));
                top = Math.max(top, iindex[i]);
            }
        }
        if (top > 254) {
            if (!implicitWarn) throw new IllegalArgumentException("the top index must be less than 254.");
            throw new IllegalArgumentException("no more than 254 colors.");
        }
        try {
            return DasColorBar.Type.parse((String)name);
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.FINE, "creating type \"{0}\"", name);
            int[] tt = DasColorBar.Type.makeColorTable((int[])iindex, (int[])red, (int[])green, (int[])blue, (int)top, (int)bottom, (int)top);
            return new DasColorBar.Type(name, tt);
        }
    }

    private MutablePropertyDataSet ensureMutable(QDataSet ds) {
        if (ds == null) {
            return null;
        }
        return Ops.copy((QDataSet)ds);
    }

    private void ensureImmutable(QDataSet ... dss) {
        for (QDataSet ds : dss) {
            MutablePropertyDataSet mpds;
            if (ds == null || !(ds instanceof MutablePropertyDataSet) || (mpds = (MutablePropertyDataSet)ds).isImmutable()) continue;
            mpds.makeImmutable();
        }
    }

    public void plot(int chNum, String label, QDataSet ds) {
        this.maybeInitModel();
        MutablePropertyDataSet yds = this.ensureMutable(ds);
        this.state.model.setDataSet(chNum, label, (QDataSet)yds);
        this.ensureImmutable(ds);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y) {
        this.plot(chNum, label, x, y, (String)null);
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, String renderType) {
        this.plot(chNum, label, x, y, renderType, true);
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, String renderType, boolean reset) {
        this.maybeInitModel();
        if (x == null && renderType == null) {
            this.state.model.setDataSet(chNum, label, y, reset);
        } else {
            QDataSet xds = x;
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (xds != null && yds != null) {
                if (yds.rank() == 0) {
                    yds.putProperty("CONTEXT_0", (Object)xds);
                } else {
                    yds.putProperty("DEPEND_0", (Object)xds);
                }
            }
            if (yds != null && (xds != null || renderType != null)) {
                yds.putProperty("RENDER_TYPE", (Object)renderType);
            }
            this.state.model.setDataSet(chNum, label, (QDataSet)yds);
        }
        this.ensureImmutable(x, y);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z) {
        this.maybeInitModel();
        QDataSet xds = x;
        if (z == null) {
            throw new IllegalArgumentException("z is null");
        }
        if (z.rank() == 1) {
            QDataSet zds = z;
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y is null");
            }
            yds.putProperty("DEPEND_0", (Object)xds);
            yds.putProperty("PLANE_0", (Object)zds);
            this.state.model.setDataSet(chNum, label, (QDataSet)yds);
        } else {
            QDataSet yds = y;
            MutablePropertyDataSet zds = this.ensureMutable(z);
            if (xds != null) {
                zds.putProperty("DEPEND_0", (Object)xds);
            }
            if (yds != null) {
                zds.putProperty("DEPEND_1", (Object)yds);
            }
            this.state.model.setDataSet(chNum, label, (QDataSet)zds);
        }
        this.ensureImmutable(x, y, z);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z, String renderType) {
        this.maybeInitModel();
        QDataSet xds = x;
        MutablePropertyDataSet zds = this.ensureMutable(z);
        if (zds == null) {
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", (Object)renderType);
            yds.putProperty("DEPEND_0", (Object)xds);
            this.state.model.setDataSet(chNum, label, (QDataSet)yds);
        } else if (zds.rank() == 1) {
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", (Object)renderType);
            yds.putProperty("DEPEND_0", (Object)xds);
            yds.putProperty("PLANE_0", (Object)zds);
            this.state.model.setDataSet(chNum, label, (QDataSet)yds);
        } else {
            QDataSet yds = y;
            zds.putProperty("RENDER_TYPE", (Object)renderType);
            if (x != null) {
                zds.putProperty("DEPEND_0", (Object)xds);
            }
            if (y != null) {
                zds.putProperty("DEPEND_1", (Object)yds);
            }
            this.state.model.setDataSet(chNum, label, (QDataSet)zds);
        }
        this.ensureImmutable(x, y, z);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public void plot(int chNum, String label, QDataSet x, QDataSet y, QDataSet z, String renderType, boolean reset) {
        this.maybeInitModel();
        QDataSet xds = x;
        MutablePropertyDataSet zds = this.ensureMutable(z);
        if (zds == null) {
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", (Object)renderType);
            yds.putProperty("DEPEND_0", (Object)xds);
            this.state.model.setDataSet(chNum, label, (QDataSet)yds, reset);
        } else if (zds.rank() == 1) {
            MutablePropertyDataSet yds = this.ensureMutable(y);
            if (yds == null) {
                throw new IllegalArgumentException("y cannot be null if z is null");
            }
            yds.putProperty("RENDER_TYPE", (Object)renderType);
            yds.putProperty("DEPEND_0", (Object)xds);
            yds.putProperty("PLANE_0", (Object)zds);
            this.state.model.setDataSet(chNum, label, (QDataSet)yds, reset);
        } else {
            QDataSet yds = y;
            zds.putProperty("RENDER_TYPE", (Object)renderType);
            if (x != null) {
                zds.putProperty("DEPEND_0", (Object)xds);
            }
            if (y != null) {
                zds.putProperty("DEPEND_1", (Object)yds);
            }
            this.state.model.setDataSet(chNum, label, (QDataSet)zds, reset);
        }
        this.ensureImmutable(x, y, z);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.state.model.waitUntilIdle();
        }
    }

    public int addPlotElement(int chNum) {
        this.maybeInitModel();
        DataSourceFilter dsf = this.state.dom.getDataSourceFilters(chNum);
        List<PlotElement> pes = this.state.dom.getController().getPlotElementsFor(dsf);
        if (pes.isEmpty()) {
            throw new IllegalArgumentException("nothing plotted that is listening to this channel number.");
        }
        String plotId = pes.get(0).getPlotId();
        Plot plot = (Plot)DomUtil.getElementById(this.state.dom, plotId);
        PlotElement pe = this.state.dom.getController().addPlotElement(plot, null, null);
        dsf = this.state.dom.getController().getDataSourceFilterFor(pe);
        int newChNum = -1;
        DataSourceFilter[] dsfs = this.state.dom.getDataSourceFilters();
        for (int i = 0; i < dsfs.length; ++i) {
            if (dsfs[i] != dsf) continue;
            newChNum = i;
            break;
        }
        return newChNum;
    }

    public MouseModule addMouseModule(Plot plot, String label, PyFunction listener) {
        DasPlot p = plot.getController().getDasPlot();
        BoxSelectorMouseModule mm = new BoxSelectorMouseModule((DasCanvasComponent)p, p.getXAxis(), p.getYAxis(), null, (DragRenderer)new BoxRenderer((DasCanvasComponent)p, true), label);
        BoxSelectionListener bsl = e -> listener.__call__(Py.java2py((Object)e));
        mm.addBoxSelectionListener(bsl);
        p.getDasMouseInputAdapter().setPrimaryModule((MouseModule)mm);
        return mm;
    }

    public void addTopDecoration(DomNode node, final PyFunction painter) {
        if (!(node instanceof Plot) && !(node instanceof Canvas)) {
            throw new IllegalArgumentException("first argument must be plot or canvas");
        }
        if (node instanceof Plot) {
            Plot p = (Plot)node;
            Painter thep = new Painter(){

                public void paint(Graphics2D g) {
                    painter.__call__(Py.java2py((Object)g));
                }
            };
            p.getController().getDasPlot().setTopDecorator(thep);
        } else if (node instanceof Canvas) {
            Canvas c = (Canvas)node;
            Painter thep = new Painter(){

                public void paint(Graphics2D g) {
                    painter.__call__(Py.java2py((Object)g));
                }
            };
            c.getController().getDasCanvas().addTopDecorator(thep);
        }
    }

    public void addBottomDecoration(DomNode node, final PyFunction painter) {
        if (!(node instanceof Plot) && !(node instanceof Canvas)) {
            throw new IllegalArgumentException("first argument must be plot or canvas");
        }
        if (node instanceof Plot) {
            Plot p = (Plot)node;
            Painter thep = new Painter(){

                public void paint(Graphics2D g) {
                    painter.__call__(Py.java2py((Object)g));
                }
            };
            p.getController().getDasPlot().setBottomDecorator(thep);
        } else if (node instanceof Canvas) {
            Canvas c = (Canvas)node;
            Painter thep = new Painter(){

                public void paint(Graphics2D g) {
                    painter.__call__(Py.java2py((Object)g));
                }
            };
            c.getController().getDasCanvas().addBottomDecorator(thep);
        }
    }

    public DataPointRecorder createDataPointRecorder() {
        final DataPointRecorder result = new DataPointRecorder(true);
        JButton button = new JButton("Export Data...");
        AnonymousDataSource dss = new AnonymousDataSource(){

            public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
                return result.getDataPoints();
            }
        };
        button.setAction(ExportDataPanel.createExportDataAction((Component)result, (DataSource)dss));
        result.addAccessory((JComponent)button);
        return result;
    }

    public ApplicationModel createApplicationModel(String id) {
        ApplicationModel result = (ApplicationModel)this.state.applets.get(id);
        if (result == null) {
            result = new ApplicationModel();
            result.addDasPeersToApp();
            result.setName(id);
            this.state.applets.put(id, result);
        }
        return result;
    }

    public void setStatus(String message) {
        this.state.dom.getController().setStatus(message);
    }

    public void alert(String message) {
        String m = message;
        int messageType = 1;
        if (m.startsWith("warning:")) {
            m = m.substring(8).trim();
            messageType = 2;
        }
        JOptionPane.showMessageDialog(this.state.view, m, "Message", messageType);
        this.state.dom.getController().setStatus("warning: " + m);
    }

    public void showMessageDialog(String message) {
        this.showMessageDialog(this.state.view, message);
    }

    public void showMessageDialog(Component parent, String message) {
        if (parent == null) {
            parent = this.state.view;
        }
        if (message.split("\n").length > 15) {
            JScrollPane pane = new JScrollPane(new JTextArea(message));
            pane.setPreferredSize(new Dimension(800, 600));
            pane.setMaximumSize(new Dimension(800, 600));
            JOptionPane.showMessageDialog(parent, pane);
        } else {
            JOptionPane.showMessageDialog(parent, message);
        }
    }

    public void addTab(final String label, final JComponent c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ScriptContext2023.this.maybeInitView();
                int n = ScriptContext2023.this.state.view.getTabs().getComponentCount();
                for (int i = 0; i < n; ++i) {
                    String titleAt = ScriptContext2023.this.state.view.getTabs().getTitleAt(i);
                    if (!titleAt.equals(label) && !titleAt.equals("(" + label + ")")) continue;
                    ScriptContext2023.this.state.view.getTabs().remove(i);
                    break;
                }
                if (GuiUtil.hasScrollPane((JComponent)c)) {
                    ScriptContext2023.this.state.view.getTabs().add(label, (Component)c);
                } else {
                    JScrollPane jsp = new JScrollPane();
                    jsp.getViewport().add(c);
                    ScriptContext2023.this.state.view.getTabs().add(label, (Component)jsp);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void setRenderStyle(String name) {
        this.state.dom.getController().getPlotElement().setRenderType(RenderType.valueOf(name));
    }

    public void peekAt(Object o) throws IOException {
        this.state.out.write(o.toString().getBytes());
    }

    private String getLocalFilename(String filename) {
        String fp;
        String qp = null;
        int iq = filename.indexOf(63);
        if (iq > -1) {
            fp = filename.substring(0, iq);
            qp = filename.substring(iq);
        } else {
            fp = filename;
        }
        if (filename.contains("/") || filename.contains("\\")) {
            URISplit split = URISplit.parse((String)filename);
            if (split.path == null) {
                throw new IllegalArgumentException("something is wrong with the specified filename: " + filename);
            }
            if (!"file".equals(split.scheme)) {
                throw new IllegalArgumentException("cannot write to " + filename + " because it must be local file");
            }
            if (fp.startsWith("file:")) {
                filename = split.file.substring(split.scheme.length() + 1);
                if (split.params != null) {
                    filename = filename + "?" + split.params;
                }
                if (filename.startsWith("///")) {
                    filename = filename.substring(2);
                }
                return filename;
            }
            if (qp != null) {
                return fp + qp;
            }
            return fp;
        }
        String pwd = new File("").getAbsolutePath();
        return pwd + File.separator + filename;
    }

    public void writeToPng(String filename) throws IOException {
        this.setStatus("writing to " + filename);
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        filename = this.getLocalFilename(filename);
        this.waitUntilIdle();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        logger.log(Level.FINER, "writeToPng {0} by {1} {2}", new Object[]{width, height, filename});
        this.writeToPng(filename, width, height);
        File f = new File(filename);
        this.setStatus("wrote to " + f.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void maybeMakeParent(String filename) throws IOException {
        File file = new File(filename = this.getLocalFilename(filename));
        File parentFile = file.getParentFile();
        if (parentFile == null || parentFile.exists()) return;
        Class<ScriptContext2023> clazz = ScriptContext2023.class;
        synchronized (ScriptContext2023.class) {
            if (parentFile.exists() || parentFile.mkdirs()) return;
            throw new IOException("unable to mkdir: " + file.getParentFile());
        }
    }

    public void writeToPng(String filename, int width, int height) throws IOException {
        filename = this.getLocalFilename(filename);
        BufferedImage image = ((State)this.state).model.canvas.getImage(width, height);
        Logger llogger = Logger.getLogger("autoplot.scriptcontext.writeToPng");
        llogger.log(Level.FINE, "writeToPng({0},{1},{2})->{3},{4} image.", new Object[]{filename, width, height, image.getWidth(), image.getHeight()});
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("Software", "Autoplot");
        meta.put("plotInfo", ((State)this.state).model.canvas.getImageMetadata());
        this.writeToPng(image, filename, meta);
    }

    public void writeToPng(String filename, int width, int height, Map<String, String> metadata) throws IOException {
        filename = this.getLocalFilename(filename);
        BufferedImage image = ((State)this.state).model.canvas.getImage(width, height);
        Logger llogger = Logger.getLogger("autoplot.scriptcontext.writeToPng");
        llogger.log(Level.FINE, "writeToPng({0},{1},{2})->{3},{4} image.", new Object[]{filename, width, height, image.getWidth(), image.getHeight()});
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.putAll(metadata);
        meta.put("Software", "Autoplot");
        meta.put("plotInfo", ((State)this.state).model.canvas.getImageMetadata());
        this.writeToPng(image, filename, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToPng(BufferedImage image, String filename, Map<String, String> metadata) throws IOException {
        logger.log(Level.CONFIG, "writeToPng(image,{0},metadata)", new Object[]{filename});
        if (!filename.endsWith(".png") && !filename.endsWith(".PNG")) {
            filename = filename + ".png";
        }
        filename = this.getLocalFilename(filename);
        this.waitUntilIdle();
        this.maybeMakeParent(filename);
        FileOutputStream out1 = new FileOutputStream(filename);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        if (metadata != null) {
            for (Map.Entry<String, String> m : metadata.entrySet()) {
                encoder.addText(m.getKey(), m.getValue());
            }
        }
        try {
            encoder.write(image, (OutputStream)out1);
        }
        catch (IOException ioe) {
            try {
                out1.close();
            }
            catch (IOException ioe2) {
                throw new RuntimeException(ioe2);
            }
        }
        finally {
            try {
                out1.close();
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
    }

    public void writeToPng(OutputStream out) throws IOException {
        this.waitUntilIdle();
        DasCanvas c = this.state.model.getCanvas();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        BufferedImage image = c.getImage(width, height);
        DasPNGEncoder encoder = new DasPNGEncoder();
        encoder.addText("Creation Time", new Date().toString());
        encoder.addText("Software", "Autoplot");
        encoder.addText("plotInfo", c.getImageMetadata());
        encoder.write(image, out);
    }

    public void writeToSvg(String filename) throws IOException {
        this.setStatus("writing to " + filename);
        if (!filename.endsWith(".svg") && !filename.endsWith(".SVG")) {
            filename = filename + ".svg";
        }
        filename = this.getLocalFilename(filename);
        this.waitUntilIdle();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        this.state.model.getCanvas().setSize(width, height);
        this.state.model.getCanvas().validate();
        this.waitUntilIdle();
        this.maybeMakeParent(filename);
        this.state.model.getCanvas().writeToSVG(filename);
        this.setStatus("wrote to " + filename);
    }

    public void writeToSvg(OutputStream out) throws IOException {
        this.waitUntilIdle();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        this.state.model.getCanvas().setSize(width, height);
        this.state.model.getCanvas().validate();
        this.waitUntilIdle();
        this.state.model.getCanvas().writeToGraphicsOutput(out, (GraphicsOutput)new SvgGraphicsOutput());
    }

    public void writeToPdf(String filename) throws IOException {
        this.setStatus("writing to " + filename);
        if (!filename.endsWith(".pdf") && !filename.endsWith(".PDF")) {
            filename = filename + ".pdf";
        }
        filename = this.getLocalFilename(filename);
        this.waitUntilIdle();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        this.state.model.getCanvas().setSize(width, height);
        this.state.model.getCanvas().validate();
        this.waitUntilIdle();
        this.maybeMakeParent(filename);
        this.state.model.getCanvas().writeToPDF(filename);
        this.setStatus("wrote to " + filename);
    }

    public void writeToPdf(OutputStream out) throws IOException {
        this.waitUntilIdle();
        int width = this.state.model.getDom().getCanvases(0).getWidth();
        int height = this.state.model.getDom().getCanvases(0).getHeight();
        this.state.model.getCanvas().setSize(width, height);
        this.state.model.getCanvas().validate();
        this.waitUntilIdle();
        this.state.model.getCanvas().writeToGraphicsOutput(out, (GraphicsOutput)new PdfGraphicsOutput());
    }

    public BufferedImage writeToBufferedImage(Application applicationIn) {
        for (DataSourceFilter dsf : applicationIn.getDataSourceFilters()) {
            if (!dsf.getUri().equals("vap+internal:")) continue;
            logger.fine("copy over vap+internal datasets.");
        }
        ApplicationModel appmodel = new ApplicationModel();
        appmodel.addDasPeersToAppAndWait();
        appmodel.getDocumentModel().syncTo(applicationIn);
        DomUtil.copyOverInternalData(applicationIn, appmodel.getDocumentModel());
        int height = applicationIn.getCanvases(0).getHeight();
        int width = applicationIn.getCanvases(0).getWidth();
        BufferedImage image = appmodel.getCanvas().getImage(width, height);
        return image;
    }

    public BufferedImage writeToBufferedImage() {
        this.waitUntilIdle();
        int height = this.state.model.getDocumentModel().getCanvases(0).getHeight();
        int width = this.state.model.getDocumentModel().getCanvases(0).getWidth();
        BufferedImage image = this.state.model.getDocumentModel().getCanvases(0).getController().getDasCanvas().getImage(width, height);
        return image;
    }

    public String[] getTimeRangesFor(String surl, String timeRange, String format) throws IOException, ParseException {
        return Util.getTimeRangesFor((String)surl, (String)timeRange, (String)format);
    }

    public String[] generateTimeRanges(String spec, String srange) throws ParseException {
        return Util.generateTimeRanges((String)spec, (String)srange);
    }

    public String[] getCompletions(String file) throws Exception {
        return Util.getAllCompletions((String)file);
    }

    public void sleep(int millis) {
        Util.sleep((int)millis);
    }

    public void formatDataSet(QDataSet ds, String file) throws Exception {
        this.formatDataSet(ds, file, (ProgressMonitor)new NullProgressMonitor());
    }

    public void formatDataSet(QDataSet ds, String file, ProgressMonitor monitor) throws Exception {
        DataSourceFormat format;
        if (!file.startsWith("/") && !file.startsWith("vap+")) {
            String s;
            file = s = this.getLocalFilename(file);
        }
        try {
            format = DataSetURI.getDataSourceFormat((URI)DataSetURI.getURI((String)file));
        }
        catch (URISyntaxException ex) {
            URISplit split = URISplit.parse((String)file);
            URI uri = split.resourceUri;
            format = DataSetURI.getDataSourceFormat((URI)uri);
        }
        if (format == null) {
            throw new IllegalArgumentException("no format for extension: " + file);
        }
        try {
            format.formatData(file, ds, monitor);
        }
        catch (FileNotFoundException ex) {
            if (file.contains(":") && System.getProperty("os.name").startsWith("Windows")) {
                FileNotFoundException ex2 = new FileNotFoundException("Output filenames on Windows cannot contain colons");
                ex2.initCause(ex);
                throw ex2;
            }
            throw ex;
        }
    }

    public void setTitle(String title) {
        this.state.model.getDom().getController().getPlot().setTitle(title);
    }

    public void createGui() {
        this.maybeInitView();
    }

    public ApplicationModel getApplicationModel() {
        this.maybeInitModel();
        return this.state.model;
    }

    public boolean isModelInitialized() {
        return this.state.model != null;
    }

    public void bind(Object src, String srcProp, Object dst, String dstProp) {
        this.bind(src, srcProp, dst, dstProp, null);
    }

    public void bind(Object src, String srcProp, Object dst, String dstProp, Converter c) {
        if (DasApplication.hasAllPermission()) {
            if (src instanceof DomNode && this.state.dom.getController().getElementById(((DomNode)src).getId()) == src) {
                DomNode srcNode = (DomNode)src;
                this.state.dom.getController().bind(srcNode, srcProp, dst, dstProp, c);
            } else {
                BeanProperty srcbp = BeanProperty.create((String)srcProp);
                Object value = srcbp.getValue(src);
                if (value == null) {
                    System.err.println("warning: src property " + srcProp + " of " + src + " is null");
                }
                BeanProperty dstbp = BeanProperty.create((String)dstProp);
                dstbp.setValue(dst, value);
                dstbp.getValue(dst);
                AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)src, (Property)srcbp, (Object)dst, (Property)dstbp);
                if (c != null) {
                    b.setConverter(c);
                }
                b.bind();
            }
        } else {
            System.err.println("bindings disabled in applet environment");
        }
    }

    public void unbind(DomNode src) {
        this.state.dom.getController().unbind(src);
    }

    public void unbind(DomNode src, String srcProp, DomNode dst, String dstProp) {
        this.state.dom.getController().unbind(src, srcProp, dst, dstProp);
    }

    public void bindGuiSafe(final Object src, final String srcProp, final Object dst, final String dstProp, final Converter c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ScriptContext2023.this.bind(src, srcProp, dst, dstProp, c);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
    }

    public void dumpToQStream(QDataSet ds, OutputStream out, boolean ascii) throws IOException {
        try {
            SimpleStreamFormatter f = new SimpleStreamFormatter();
            f.format(ds, out, ascii);
        }
        catch (StreamException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    public void dumpToDas2Stream(QDataSet ds, boolean ascii) {
        try {
            ByteArrayOutputStream bufout = new ByteArrayOutputStream(10000);
            DataSet lds = DataSetAdapter.createLegacyDataSet((QDataSet)ds);
            if (ascii) {
                if (lds instanceof TableDataSet) {
                    TableUtil.dumpToAsciiStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
                } else {
                    VectorUtil.dumpToAsciiStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
                }
            } else if (lds instanceof TableDataSet) {
                TableUtil.dumpToBinaryStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
            } else {
                VectorUtil.dumpToBinaryStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
            }
            this.state.out.write(bufout.toByteArray());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void dumpToDas2Stream(QDataSet ds, String file, boolean ascii) throws IOException {
        file = this.getLocalFilename(file);
        FileOutputStream bufout = new FileOutputStream(file);
        DataSet lds = DataSetAdapter.createLegacyDataSet((QDataSet)ds);
        if (ascii) {
            if (lds instanceof TableDataSet) {
                TableUtil.dumpToAsciiStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
            } else {
                VectorUtil.dumpToAsciiStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
            }
        } else if (lds instanceof TableDataSet) {
            TableUtil.dumpToBinaryStream((TableDataSet)((TableDataSet)lds), (OutputStream)bufout);
        } else {
            VectorUtil.dumpToBinaryStream((VectorDataSet)((VectorDataSet)lds), (OutputStream)bufout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void mkdir(String dir) {
        if (!(dir = this.getLocalFilename(dir)).endsWith("/")) {
            throw new IllegalArgumentException("folder name must end in /");
        }
        File f = new File(dir);
        if (f.exists()) return;
        Class<ScriptContext2023> clazz = ScriptContext2023.class;
        synchronized (ScriptContext2023.class) {
            if (f.exists() || f.mkdirs()) return;
            throw new IllegalArgumentException("unable to make directory: " + f);
        }
    }

    public Application getDocumentModel() {
        this.maybeInitModel();
        return this.state.dom;
    }

    public void waitUntilIdle() {
        if (this.state.view != null) {
            while (this.state.view.getDataSetSelector().isPendingChanges()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        this.state.model.waitUntilIdle();
    }

    public void waitUntilIdle(String id) {
        logger.log(Level.INFO, "waitUntilIdle({0})", id);
        if (this.state.view != null) {
            while (this.state.view.getDataSetSelector().isPendingChanges()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(ScriptContext2023.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.state.model.waitUntilIdle();
    }

    public void save(String filename) throws IOException {
        this.maybeInitModel();
        filename = this.getLocalFilename(filename);
        if (!filename.endsWith(".vap")) {
            throw new IllegalArgumentException("filename must end in vap");
        }
        this.state.model.doSave(new File(filename));
    }

    public void load(String filename) throws IOException {
        this.plot(filename);
    }

    public Application loadVap(String filename) throws IOException {
        try {
            File f = FileSystemUtil.doDownload((String)filename, (ProgressMonitor)new NullProgressMonitor());
            return (Application)StatePersistence.restoreState(f);
        }
        catch (FileSystem.FileSystemOfflineException ex) {
            throw new IOException(ex);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void saveVap(Application dom, String filename) throws IOException {
        StatePersistence.saveState(new File(filename), dom);
    }

    public void fixLayout() {
        DomOps.newCanvasLayout(this.state.dom);
    }

    public void setLayout(int nrows) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        this.setLayout(nrows, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayout(int nrows, int ncolumns) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        if (ncolumns < 1) {
            throw new IllegalArgumentException("must be one or more columns");
        }
        this.reset();
        DasCanvas c = this.state.dom.getCanvases(0).getController().getDasCanvas();
        Lock canvasLock = c.mutatorLock();
        ChangesSupport.DomLock lock = this.state.dom.getController().mutatorLock();
        try {
            canvasLock.lock();
            lock.lock();
            Plot p = this.state.dom.getController().getPlot();
            this.state.dom.getController().addPlots(nrows, ncolumns, null);
            this.state.dom.getController().deletePlot(p);
        }
        finally {
            lock.unlock();
            canvasLock.unlock();
        }
        this.waitUntilIdle();
    }

    public List<Plot> addPlots(int nrows, int ncolumns, String dir) {
        if (nrows < 1) {
            throw new IllegalArgumentException("must be one or more rows");
        }
        if (ncolumns < 1) {
            throw new IllegalArgumentException("must be one or more columns");
        }
        Plot d = null;
        if (dir == null) {
            d = this.state.dom.getController().getPlot();
        }
        List<Plot> result = this.state.dom.getController().addPlots(nrows, ncolumns, dir);
        if (dir == null) {
            this.state.dom.getController().deletePlot(d);
        }
        if (result.size() > 0) {
            this.state.dom.getController().setPlot(result.get(0));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLayoutOverplot(int nplotElement) {
        if (nplotElement < 1) {
            throw new IllegalArgumentException("must be one or more plots");
        }
        this.reset();
        DasCanvas c = this.state.dom.getCanvases(0).getController().getDasCanvas();
        Lock canvasLock = c.mutatorLock();
        ChangesSupport.DomLock lock = this.state.dom.getController().mutatorLock();
        try {
            canvasLock.lock();
            lock.lock();
            Plot p = this.state.dom.getController().getPlot();
            for (int i = 1; i < nplotElement; ++i) {
                this.state.dom.getController().addPlotElement(p, null);
            }
        }
        finally {
            lock.unlock();
            canvasLock.unlock();
        }
    }

    public void reset() {
        this.maybeInitModel();
        this.state.dom.getController().reset();
        AutoplotUI ui = this.getApplication();
        if (ui != null) {
            ui.getUndoRedoSupport().resetHistory();
        }
    }

    protected void close() {
        this.state.model = null;
        this.state.view = null;
        this.state.out = null;
    }

    public static class State {
        private ApplicationModel model = null;
        private Application dom = null;
        private final Map<String, AutoplotUI> apps = new HashMap<String, AutoplotUI>();
        private final Map<String, ApplicationModel> applets = new HashMap<String, ApplicationModel>();
        private final Map<ApplicationModel, AutoplotUI> appLookup = new HashMap<ApplicationModel, AutoplotUI>();
        private AutoplotUI view = null;
        private AutoplotUI defaultApp = null;
        private OutputStream out = System.out;
    }
}

